#!/bin/sh

# luna firmware upgrade  script
# $1 image destination (0 or 1) 
# Kernel and root file system images are assumed to be located at the same directory named uImage and rootfs respectively
# ToDo: use arugements to refer to kernel/rootfs location.

########### G3 ##########################################################
### dtb    : ca7774-engboard.dtb or ca8276 Device Tree Binary ###########
### kimage : Image or Image.lzma
### rootfs : rootfs_G3_1.ubi
#########################################################################
d_img="dtb"
k_img="uImage"
r_img="rootfs"
c_img="custconf"
img_ver="fwu_ver"
md5_cmp="md5.txt"
md5_cmd="/bin/md5sum"
#md5 run-time result
md5_tmp="md5_tmp" 
md5_rt_result="md5_rt_result.txt"
new_fw_ver="new_fw_ver.txt"
cur_fw_ver="cur_fw_ver.txt"
env_sw_ver="env_sw_ver.txt"
hw_ver_file="hw_ver"
skip_hwver_check="/tmp/skip_hwver_check"

upgrade_dtb=0
upgrade_kernel=1
upgrade_rootfs=1
upgrade_custconf=0


# Stop this script upon any error
# set -e

kernel_dst=$1
rootfs_dst=$1
custconf_dst=$1


echo "Updating image $1 with file $2"

if [ "`tar -tf $2 $d_img`" = "$d_img" ]; then
	upgrade_dtb=1
fi

if [ "`tar -tf $2 $k_img`" != "$k_img" ]; then
	upgrade_kernel=0
fi

if [ "`tar -tf $2 $r_img`" != "$r_img" ]; then
	upgrade_rootfs=0
fi

if [ "`tar -tf $2 $c_img`" = "$c_img" ]; then
	upgrade_custconf=1
fi

#add by cwz for single partition
if [ $upgrade_kernel = 1 ]; then
	cat /proc/mtd | grep "mtd[0-9]*.*\"k$kernel_dst\""
	if [ $? = 1 ];then
		echo "!Can't find mtd - k$kernel_dst"
		if [ $kernel_dst = 1 ];then
			kernel_dst=0
		else
			kernel_dst=1
		fi
		echo "!Switch to Update image $kernel_dst with file $2"
	fi
fi

if [ $upgrade_rootfs = 1 ]; then
	cat /proc/mtd | grep "mtd[0-9]*.*\"r$rootfs_dst\""
	if [ $? = 1 ];then
		echo "!Can't find mtd - r$rootfs_dst"
		if [ $rootfs_dst = 1 ];then
			rootfs_dst=0
		else
			rootfs_dst=1
		fi
		echo "!Switch to Update image $rootfs_dst with file $2"
	fi
fi

if [ $upgrade_custconf = 1 ]; then
	cat /proc/mtd | grep "mtd[0-9]*.*\"framework$(($custconf_dst+1))\""
	if [ $? = 1 ];then
		echo "!Can't find mtd - framework$(($custconf_dst+1))"
		if [ $custconf_dst = 1 ];then
			custconf_dst=0
		else
			custconf_dst=1
		fi
		echo "!Switch to Update image $custconf_dst with file $2"
	fi
fi

# Find out kernel/rootfs mtd partition according to image destination
if [ $upgrade_dtb = 1 ]; then
	d_mtd="/dev/"`cat /proc/mtd | grep \"DTB"$1"\" | sed 's/:.*$//g'`
	d_mtd_size=`cat /proc/mtd | grep \"DTB"$1"\" | sed 's/^.*: //g' | sed 's/ .*$//g'`
	echo "DTB image is located at $d_mtd"
fi
if [ $upgrade_kernel = 1 ]; then
	k_mtd="/dev/"`cat /proc/mtd | grep \"k"$kernel_dst"\" | sed 's/:.*$//g'`
	k_mtd_size=`cat /proc/mtd | grep \"k"$kernel_dst"\" | sed 's/^.*: //g' | sed 's/ .*$//g'`
	echo "kernel image is located at $k_mtd"
fi
if [ $upgrade_rootfs = 1 ]; then
	r_mtd="/dev/"`cat /proc/mtd | grep \"r"$rootfs_dst"\" | sed 's/:.*$//g'`
	r_mtd_size=`cat /proc/mtd | grep \"r"$rootfs_dst"\" | sed 's/^.*: //g' | sed 's/ .*$//g'`
	echo "rootfs image is located at $r_mtd"
fi
if [ $upgrade_custconf = 1 ]; then
	c_mtd="/dev/"`cat /proc/mtd | grep \"framework"$(($custconf_dst+1))"\" | sed 's/:.*$//g'`
	c_mtd_size=`cat /proc/mtd | grep \"framework"$(($custconf_dst+1))"\" | sed 's/^.*: //g' | sed 's/ .*$//g'`
	echo "custconf image is located at $c_mtd"
fi


if [ -f $skip_hwver_check ]; then
    echo "Skip HW_VER check!!"
else
    img_hw_ver=`tar -xf $2 $hw_ver_file -O`
    mib_hw_ver=`mib get HW_HWVER | sed s/HW_HWVER=//g`
    if [ "$img_hw_ver" = "skip" ]; then
        echo "skip HW_VER check!!"
    else
        echo "img_hw_ver=$img_hw_ver mib_hw_ver=$mib_hw_ver"
        if [ "$img_hw_ver" != "$mib_hw_ver" ]; then
            echo "HW_VER $img_hw_ver inconsistent, aborted image updating !"
            exit 1
        fi
    fi
fi

# Extract DTB image
if [ $upgrade_dtb = 1 ]; then
	tar -xf $2 $d_img -O | md5sum | sed 's/-/'$d_img'/g' > $md5_rt_result
	# Check integrity
	grep $d_img $md5_cmp > $md5_tmp
	diff $md5_rt_result $md5_tmp

	if [ $? != 0 ]; then
		echo "$d_img""md5_sum inconsistent, aborted image updating !"
		exit 1
	fi
fi

# Extract kernel image
if [ $upgrade_kernel = 1 ]; then
	tar -xf $2 $k_img -O | md5sum | sed 's/-/'$k_img'/g' > $md5_rt_result
	# Check integrity
	grep $k_img $md5_cmp > $md5_tmp
	diff $md5_rt_result $md5_tmp

	if [ $? != 0 ]; then
		echo "$k_img""md5_sum inconsistent, aborted image updating !"
		exit 1
	fi
fi

# Extract rootfs image
if [ $upgrade_rootfs = 1 ]; then
	tar -xf $2 $r_img -O | md5sum | sed 's/-/'$r_img'/g' > $md5_rt_result
	# Check integrity
	grep $r_img $md5_cmp > $md5_tmp
	diff $md5_rt_result $md5_tmp

	if [ $? != 0 ]; then
		# rm $r_img
		echo "$r_img""md5_sum inconsistent, aborted image updating !"
		exit 1
	fi
fi

# Extract custconf image
if [ $upgrade_custconf = 1 ]; then
	tar -xf $2 $c_img -O | md5sum | sed 's/-/'$c_img'/g' > $md5_rt_result
	# Check integrity
	grep $c_img $md5_cmp > $md5_tmp
	diff $md5_rt_result $md5_tmp

	if [ $? != 0 ]; then
		# rm $c_img
		echo "$c_img""md5_sum inconsistent, aborted image updating !"
		exit 1
	fi
fi

echo "Integrity of $k_img & $r_img is okay, start updating"

# Check upgrade firmware's version with current firmware version
tar -xf $2 $img_ver
if [ $? != 0 ]; then
	echo "1" > /var/firmware_upgrade_status
	echo "Firmware version incorrect: no fwu_ver in img.tar !"
	exit 1
fi

cat $img_ver > $new_fw_ver
cat /etc/version > $cur_fw_ver

cat $new_fw_ver | grep -n '^V[0-9]*.[0-9]*.[0-9]*'
if [ $? != 0 ]; then
	echo "1" > /var/firmware_upgrade_status
	echo "Firmware version incorrect: `cat $new_fw_ver` !"
	exit 1
fi

echo "Try to upgrade firmware version from `cat $cur_fw_ver`"
echo "                                  to `cat $new_fw_ver`"

# if [ "`cat $new_fw_ver`" == "`cat $cur_fw_ver`" ]; then
# 	echo "4" > /var/firmware_upgrade_status
# 	echo "Current firmware version already is `cat $cur_fw_ver` !"
# 	exit 1
# fi

echo "Firware version check okay."

flash set PORT_REMAPPING "03,02,01,00,08,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00"

##### DTB ####
if [ $upgrade_dtb = 1 ]; then
	tar -xf $2 $d_img
	string="`ls -l | grep $d_img`"
	mtd_size_dec="`printf %d 0x$d_mtd_size`"
	img_size_dec="`expr substr "$string" 34 100 | sed 's/^ *//g' | sed 's/ .*$//g'`"
	expr "$img_size_dec" \< "$mtd_size_dec" > /dev/null
	if [ $? != 0 ]; then
		echo "DTB size too big($img_size_dec) !"
		echo "3" > /var/firmware_upgrade_status
		exit 1
	fi
fi

##### Kernel #####
if [ $upgrade_kernel = 1 ]; then
	tar -xf $2 $k_img
	string="`ls -l | grep $k_img`"
	mtd_size_dec="`printf %d 0x$k_mtd_size`"
	img_size_dec="`expr substr "$string" 34 100 | sed 's/^ *//g' | sed 's/ .*$//g'`"
	expr "$img_size_dec" \< "$mtd_size_dec" > /dev/null
	if [ $? != 0 ]; then
		echo "uImage size too big($img_size_dec) !"
		echo "3" > /var/firmware_upgrade_status
		exit 1
	fi
fi
##### rootfs #####
if [ $upgrade_rootfs = 1 ]; then
	tar -xf $2 $r_img
	string="`ls -l | grep $r_img`"
	mtd_size_dec="`printf %d 0x$r_mtd_size`"
	#img_size_dec="`expr substr "$string" 34 100 | sed 's/^ *//g' | sed 's/ .*$//g'`"
	img_size_dec="`echo $string | sed 's/.*root[ ]*[0-9]*[ ]*\([0-9]*\)[ ]*.*/\1/'`"
	expr "$img_size_dec" \< "$mtd_size_dec" > /dev/null
	if [ $? != 0 ]; then
		echo "rootfs size too big($img_size_dec) !"
		echo "3" > /var/firmware_upgrade_status
		exit 1
	fi
fi

##### custconf #####
if [ $upgrade_custconf = 1 ]; then
	tar -xf $2 $c_img
	string="`ls -l | grep $c_img`"
	mtd_size_dec="`printf %d 0x$c_mtd_size`"
	#img_size_dec="`expr substr "$string" 34 100 | sed 's/^ *//g' | sed 's/ .*$//g'`"
	img_size_dec="`ls -l $c_img | awk '{print $5}'`"
	expr "$img_size_dec" \< "$mtd_size_dec" > /dev/null
	if [ $? != 0 ]; then
		echo "custconf size too big($img_size_dec) !"
		echo "3" > /var/firmware_upgrade_status
		exit 1
	fi
fi

if [ $upgrade_dtb = 1 ]; then
	echo "DTB , kernel and rootfs size check okay, start updating ..."
	# Erase DTB partition 
	flash_eraseall $d_mtd
	# Write DTB partition
	echo "Writing $d_img to $d_mtd"
	cp $d_img $d_mtd
fi

if [ $upgrade_kernel = 1 ]; then
	# Erase kernel partition 
	flash_eraseall $k_mtd
	# Write kernel partition
	echo "Writing $k_img to $k_mtd"
	cp $k_img $k_mtd
fi

if [ $upgrade_rootfs = 1 ]; then
	# Erase rootfs partition 
	flash_eraseall $r_mtd
	# Write rootfs partition
	echo "Writing $r_img to $r_mtd"
	cp $r_img $r_mtd
fi

if [ $upgrade_custconf = 1 ]; then
	# Erase custconf partition
	flash_eraseall $c_mtd
	# Write custconf partition
	echo "Writing $c_img to $c_mtd"
	cp $c_img $c_mtd
fi

cat $new_fw_ver | grep CST
if [ $? = 0 ]; then
	echo `cat $new_fw_ver` | sed 's/ *--.*$//g' > $env_sw_ver
else
	cat $new_fw_ver > $env_sw_ver
fi
# Write image version information 
if [ -f /tmp/nv ]; then
    echo "!using /tmp/nv"
    /tmp/nv setenv sw_version"$1" "`cat $env_sw_ver`"
else
    echo "!using /bin/nv"
    nv setenv sw_version"$1" "`cat $env_sw_ver`"
fi


# Clean up temporary files
rm -f $md5_cmp $md5_tmp $md5_rt_result $img_ver $new_fw_ver $cur_fw_ver $env_sw_ver  $d_img $k_img $r_img $c_img $2

# Post processing (for future extension consideration)

echo "Successfully updated image $rootfs_dst!!"
